# All rights/write not reserved
# Octobre 2001. version 1.0.
# LimboLisp par G. KHELIDJ, ghalleb@ghalleb.com
#				S. GANA,    versace@mime.up8.edu
#				J.L. COSSI, cossi@mime.up8.edu
#				L. BENCHADI droopy@mime.up8.edu
# Please send us 4 tee-shirts "Inferno" Thanks.
# Universite Paris VIII
# DESS Informatique des systemes autonomes.


LimboLisp: module {



####	Les fonctions

#	le main et la fonction de gestion des evenement

	init: fn( ctxt: ref Draw->Context, args: list of string);
	toplevel: fn();


#	fonctions d'initialisation

	init_atomes: fn();
	init_listes: fn();
	init_stack: fn();
	init_read: fn () ;


# 	les fonctions de lecture

	is_letter: fn (ch: int) : int ;
	is_digit: fn (ch: int) : int ;
	is_separator: fn (ch: int) : int ;
	read_char: fn () : int ;
	unread_char: fn (ch: int) ;
	lisp_read: fn () ;
	obj_read: fn () : int ;
	cons_read: fn () : int ;
	int_read: fn (ch: int) : int ;
	atom_read: fn (ch: int) : int ;


#	fonction d'affichage

	lisp_print: fn();
	obj_print: fn(obj: int);
	list_print: fn(obj:int);


#	fonction d'empillage et de depillage

	push: fn(x: int);
	pop: fn(): int;


#	les fonctions d'evaluation

	eval: fn();
	eval_car: fn();
	power: fn(a: int, b:int):int;
	eval_1_arg: fn();
	eval_2_args: fn();
	eval_3_args: fn();
	progn: fn();
	evlis: fn();
	bind: fn(x:int, y:int);
	unbind: fn();


#	les fonctions classique interne de Lisp

	CAR: fn(adr: int): int;
	CDR: fn(adr: int): int;
	CAAR: fn(adr: int): int;
	CADR: fn(adr: int): int;
	CDAR: fn(adr: int): int;
	CDDR: fn(adr: int): int;


#	recuperation de la valeur

	CVAL: fn(adr: int): int;


#	detection de type

	IS_ATOM: fn(adr: int): int;
	IS_CONS: fn(adr: int): int;
	IS_STACK: fn(adr: int): int;
	IS_INT: fn(x: int): int;


#	affectation des valeurs

	setcval: fn(adr: int, val: int);
	setcar: fn(adr: int, val: int);
	setcdr: fn(adr: int, val: int);


#	recadrage des entiers

	make_int: fn(x: int): int;
	val_int: fn(x: int): int;


#	creation d'un atome

	cratom: fn(nom_at: string): int;


#	creation d'une liste

	cons: fn(x: int, y: int): int;


#	fonction d'erreur

	gc: fn();



####	Les variables

#	tableau de memoire virtuelle

	mem: array of int;


#	buffer de lecture et son pointeur

	read_buf :string;
	pos_read_buf : int ;


#	constante de division de la memoire

	B_ATOME: 	con 0;
	B_CONS: 	con 256;
	B_STACK:	con 7000;
	MAXMEM:		con 8092;


# 	le nombre d'atome en fonction de la memoire virtuelle allouee

	MAX_ATOMES:	con B_CONS - B_ATOME;


#	pointeurs de pile

	sp: int;
	freelist: int;


#	les registres

	a0: int;
	a1: int;
	a2: int;
	a3: int;
	a4: int;


# 	les constantes de Lisp

	tnil: 		con 0;
	undefined: 	con 1;
	t: 			con 2;
	quote: 		con 3;
	lambda:		con 8;


#	le nombre d'atomes connus

	no_atoms: int;


#	atome auto-evaluant

	MAX_AUTO_EVAL: 	con 3;


#	le nombre d'atome au debut

	N_ATOMS:		con 44;


#	Tableau des atomes

	p_names : array of string ;

};