# All rights/write not reserved
# Octobre 2001. version 1.0.
# LimboLisp par G. KHELIDJ, ghalleb@ghalleb.com
#				S. GANA,    versace@mime.up8.edu
#				J.L. COSSI, cossi@mime.up8.edu
#				L. BENCHADI droopy@mime.up8.edu
# Please send us 4 tee-shirts "Inferno" Thanks.
# Universite Paris VIII
# DESS Informatique des systemes autonomes.


implement LimboLisp;

include "projet.m";

include "sys.m" ;
	sys: Sys ;
include "draw.m" ;
	draw: Draw;
include "string.m" ;
	chaine: String ;
include "bufio.m" ;
	bufio: Bufio ;


mem= array[MAXMEM] of int;

p_names = array[MAX_ATOMES] of {
	"nil", "undefined", "t", "quote", "car", "cdr", "add1", "sub1", "lambda", "de", "print", "setq", "eq", "if",
	"times", "oblist", "cons", "plus", "less", "minus", "div", "caar", "cadr", "cdar","cddr", "last", "butlast",
	"middle", "max", "min", "square", "half", "length", "nconc", "delq", "equalp", "nth", "midelt", "poly",
	"val", "max3", "listadd", "mconc", "decimate"
};


# Initialise le nombre maximum des caracteres en entree.

init_read () {
	pos_read_buf = 80 ;
}


# Replace le caractere "ch" dans le buffer de lecture.

unread_char (ch: int) {
	if (pos_read_buf != 80)	{
		--pos_read_buf;
	}
}


# Ramene un caractere.

read_char () : int {
	ch : int;

	stdin := bufio->fopen(sys->fildes(0), bufio->OREAD);

	if (pos_read_buf >= 80) {
		read_buf= bufio->stdin.gets('\n');
		pos_read_buf = 0;
	}

	ch = read_buf[pos_read_buf++];

	if (ch == '\n') {
		pos_read_buf = 80;
	}

	return(ch);
}


# Lit un element et le met dans le registre "a0".

lisp_read () {
	a0 = obj_read () ;
}


# Lit un objet et le renvoie

obj_read () : int {
	ch: int ;
	res: int;

	do {
		ch = read_char();
	} while (is_separator(ch) || ch == ')') ;


	if (ch == '\'') {
		res = obj_read();
		res = cons (quote, cons(res, tnil)) ;
		return(res);
	}

	if (is_digit(ch)) {
		res = int_read (ch) ;
	}
	else {
		if (ch == '(') {
			return(cons_read ());
		}
		else {
			if (is_letter(ch)) {
				res = atom_read(ch) ;
			}
			else {
				sys->print ("Erreur read, caractere inconnu %d\n", ch) ;
			}
		}
	}

	return res;
}


# Teste si le caractere est un separateur.

is_separator (ch: int) : int {
	return (chaine->in(ch, " \t\n")) ;
}


# Lecture d'un entier.

int_read (ch: int) : int {
	val : int;

	val = ch - '0' ;

	ch = read_char () ;

	while (is_digit(ch)) {
		ch = ch - '0' ;
		val = val * 10 + ch ;
		ch = read_char () ;

	}

	unread_char (ch) ;

	return (make_int(val)) ;
}


# Lit un atome ou le cree s'il n'existe pas.

atom_read (ch: int) : int {
	res: int;
	atbuf: string;
	i: int;

	i = 0;
	atbuf[i++] = ch;

	ch = read_char();

	while (is_letter(ch) || is_digit(ch)) {
		atbuf[i++] = ch;
		ch = read_char();
	}

	unread_char(ch);

	for (i = tnil; i < no_atoms; i++) {
		if (atbuf == p_names[i]) {
			return (i);
		}
	}
	return( cratom(atbuf));
}


# Teste si le caractere est une lettre.

is_letter (ch: int) : int {
	return (chaine->in(ch, "a-zA-Z")) ;
}


# Teste si le caractere est un digit.

is_digit (ch: int) : int {
	return (chaine->in(ch, "0-9")) ;
}


# Lit une liste.

cons_read () : int {
	res: int;
	ch: int;
	x: int ;

	res =  cons (tnil, tnil) ;
	x = res;

	for (;;) {
		while (is_separator(ch = read_char())) ;

		if (ch == ')') {
			return (CDR(res)) ;
		}

		unread_char (ch) ;

		setcdr (x, cons(obj_read(), tnil)) ;

		x = CDR(x) ;
	}
}


# Appel de la fonction "obj_print" avec le registre "a0" comme source.

lisp_print()
{
	obj_print(a0);
}


# Affiche l'element selon son type.

obj_print(obj: int)
{

	if(IS_ATOM(obj)) {
		sys->print("%s",p_names[obj]);
		return;
	}

	if(IS_INT(obj)) {
		sys->print("%d",val_int(obj));
		return;
	}

	if(IS_CONS(obj)) {
		list_print(obj);
		return;
	}

	sys->print("Objet  imprimer inconnu + obj" );

}


# Affichage d'une liste.

list_print(obj: int)
{
	sys->print("(");
	for(;;) {
		obj_print(CAR(obj));
		if((obj = CDR(obj)) == 0) break ;
		sys->print(" ");
		if(IS_CONS(obj)) continue;
		sys->print(". "); obj_print(obj); break;
	}
	sys->print(")");


}


# push

push(x: int) {
	if (sp == MAXMEM - 1) {
		init_stack();
		sys->print("Pile debordee\n");
	}

	mem[++sp] = x;
}


# pop

pop(): int {
	return(mem[sp--]);
}


# Fonction principale qui est appelee au lancement de l'application.

init (ctxt: ref Draw->Context, args: list of string)
{
	sys= load Sys Sys->PATH;
	bufio= load Bufio Bufio->PATH;
	chaine= load String String->PATH;

	sys->print("LimboLisp (v1.0) par G. KHELIDJ, S. GANA, J.L. COSSI, L. BENCHADI\n");
	sys->print("DESS ISA, Universite Paris VIII\n");

	init_stack();
	init_atomes();
	init_listes();
	init_read();
	toplevel();

}


# Boucle infinie de gestion d'evenement.

toplevel() {


	for(;;) {
		sys->print("-> ");
		lisp_read();
		eval();
		sys->print("= ");
		lisp_print();
		sys->print("\n");
	}
}


# Fonction d'evaluation.

eval() {

  	if(IS_INT(a0)) {
  		return;
	}

  	if(IS_ATOM(a0)) {
      	if(CVAL(a0) == undefined && a0 != undefined) {
			sys->print("Atome %s, valeur indefinie\n",p_names[a0]);
		}
      	a0 = CVAL(a0); return;
    }

  	a4 = CAR(a0);
	eval_car();
}


# Evaluation d'un element connu.

eval_car(){
  	if(IS_INT(a4)) {
  		sys->print("Nombre en position fonctionnelle %d\n", val_int(a4));
	}

  	if(IS_ATOM(a4)) {

      	case (a4){
 			3 => 								# quote
	  			a0 = CADR(a0);
	 		4 => 								# car
	  			eval_1_arg();
	  			a0 = CAR(a0);
			5 => 								# cdr
	  			eval_1_arg();
	  			a0 = CDR(a0);
			6 => 								# add1
				eval_1_arg();
				a0 = make_int(val_int(a0) + 1);
			7 => 								# sub1
	  			eval_1_arg();
	  			a0 = make_int(val_int(a0) - 1);
			9 => 								# de
	  			a0 = CDR(a0);
			  	a1 = CAR(a0);
			  	setcval(a1, cons(lambda, CDR(a0)));
			  	a0 = a1;
			10 => 								# print
	  			eval_1_arg();
	  			obj_print(a0);
	  			sys->print("\n");
	  		11 => 								# setq
	  			push(CADR(a0));
	  			a0 = CADR(CDR(a0));
	  			eval();
	  			a1 = pop();
	 	 		setcval(a1, a0);
			12 => 								# eq
	  			eval_2_args();
	  			if(a1 == a0)
	  				a0 = t;
	  			else
	  				a0 = tnil;
			13 => 								# if
	  			push(a0);
	  			a0 = CADR(a0);
	  			eval();
	  			a1 = pop();
	  			push(a1);
	  			if(a0 == tnil)
	  				a0 = CADR(CDDR(a1));
	  			else
	  				a0 = CADR(CDR(a1));
				eval();
			14 => 								# times
	  			eval_2_args();
	  			a0 = make_int(val_int(a1) * val_int(a0));
			15 => 								# oblist
	  			a0 = tnil;
	  			for(a1 = no_atoms-1; a1 >= 0; a1--)
	    				a0 = cons(a1, a0);

 								# Fonction supplementaires

			16 => 								# cons
				eval_2_args();
				a0 = cons(a0, a1);
			17 => 								# plus
				eval_2_args();
				a0 = make_int(val_int(a0) + val_int(a1));
			18 =>  								# less
				eval_2_args();
				if(val_int(a0) < val_int(a1))
					a0 = t;
				else
					a0 = tnil;
			19 =>  								# minus
				eval_2_args();
				a0 = make_int(val_int(a0) - val_int(a1));
			20 =>  								# div
				eval_2_args();
				a0 = make_int(val_int(a0) / val_int(a1));
			21 =>  								# caar
				eval_1_arg(); a0 = CAAR(a0);
			22 =>  								# cadr
				eval_1_arg(); a0 = CADR(a0);
			23 =>  								# cdar
				eval_1_arg(); a0 = CDAR(a0);
			24 =>  								# cddr
				eval_1_arg(); a0 = CDDR(a0);
			25 =>  								# last
				eval_1_arg();
				while (CDR(a0) != tnil) a0 = CDR(a0);
					a0 = CAR(a0);
			26 =>  								# butlast
				eval_1_arg();
				a1 = a0;
				if (CDR(a1) == tnil){
					    setcar(a1, tnil);
					    return;
				}
				while(CDDR(a1) != tnil) a1 = CDR(a1);
					setcdr(a1, tnil);
			27 =>  								# middle
				eval_1_arg();
				a1 = a0;
				if (CDR(a1) == tnil){
					setcar(a1, tnil);
					return;
				}
				while(CDDR(a1) != tnil) a1 = CDR(a1);
					setcdr(a1, tnil);
					a0 = CDR(a0);
			28 =>  								# max
				eval_2_args();
				if(val_int(a0) < val_int(a1)) a0 = a1;
			29 =>  								# min
				eval_2_args();
				if(val_int(a0) > val_int(a1)) a0 = a1;
			30 =>  								# square
				eval_1_arg();
				a0 = make_int(val_int(a0) * val_int(a0));
		    31 =>  								# half
		    	eval_1_arg () ;
		    	if (CDDR(a0) == tnil) {a0 = CAR(a0) ; return ; }
				a1 = a2 = a0 ;
				while ((a1 = CDDR(a1)) != tnil) {
					if (CDR(a1) == tnil) {a0 = tnil ; return ; }
				    a2 = CDR(a2) ;

				}
                setcdr (a2, tnil) ;

			32 =>  								# length
				length := 0;
				eval_1_arg();
				if(a0 == tnil){
					a0 = make_int(length);
					return;
				}
				while(CDR(a0) != tnil){
					length++;
					a0 = CDR(a0);
				}
				a0 = make_int(++length);
			33 =>  								# nconc
				eval_2_args();
				if(a0 == tnil){
					    a0 = a1;
					    return;
				}
				a2 = a0;
				while(CDR(a2) != tnil) a2 = CDR(a2);
				setcdr(a2,a1);
			34 =>  								# delq
				eval_2_args();
				while(val_int(CAR(a1)) == val_int(a0)){
					if(CDR(a1) == tnil){
					    	a0 = tnil;
					    	return;
					}
					a1 = CDR(a1);
				}
				a2 = a1;
				while(CDR(a2) != tnil){
					if(val_int(CADR(a2)) == val_int(a0)){
						if(CDDR(a2) == tnil){
					    	setcdr(a2, tnil);
					    		return;
					    }
					    setcdr(a2, CDDR(a2));
					}
					else a2 = CDR(a2);
				}
				a0 = a1;
		    35 =>  								# equalp
				eval_2_args();
				if ((a0 == tnil) || (a1 == tnil)){
					if(a0 == a1)
						a0 = t;
					else
						a0 = tnil;
					return;
				}
				while(CAR(a0) == CAR(a1)){
					if((CDR(a0) == tnil) || (CDR(a1) == tnil)){
					    if(CDR(a0) == CDR(a1))
					    	a0 = t;
					    else
					    	a0 = tnil;
					    return;
					}
					a0 = CDR(a0);
					a1 = CDR(a1);
				}
			36 =>  								# nth
				nth: int;
				eval_2_args();
				if (a0 == tnil)
					return;
				if (val_int(a1) == 0){
					a0 = tnil;
					return;
				}
				for(nth = 1; nth < val_int(a1); nth++){
					if(CDR(a0) == tnil){
					    a0 = tnil;
					    return;
					}
					a0 = CDR(a0);
				}
				a0 = CAR(a0);
		    37 =>  								# midelt
				eval_1_arg();
				a1 = a0;
				while(CDR(a1) != tnil){
					if(CDDR(a1) == tnil){
					    a0 = tnil;
					    return;
					}
					a1 = CDDR(a1);
					a0 = CDR(a0);
				}
				a0 = CAR(a0);
			38 =>  								# poly
				eval_2_args ();
				puiss := 0 ;
				temp := 0 ;
				while (CDR(a1) != tnil) {
					temp += (val_int(CAR (a1)) * power (val_int(a0), puiss++));
					a1 = CDR (a1) ;
				}
				a0 = make_int(temp + (val_int(CAR (a1)) * power (val_int(a0), puiss)));
			39 =>  								# val
				eval_2_args();
				while(a1 != tnil){
					if(CAAR(a1) == a0){
						a0 = CAR(CDAR(a1));
							return;
					}
					else
						a1 = CDR(a1);
				}
				a0 = tnil;
			40 =>  								# max3
				eval_3_args();
				if(val_int(a0) < val_int(a1))
					if(val_int(a1) < val_int(a2))
						a0 = a2;
					else
						a0 = a1;
				else
					if(val_int(a0) < val_int(a2))
						a0 = a2;
					else
						a0 = a0;
			41 =>  								# listadd
				eval_1_arg();
				a1 = make_int(val_int(CAR(a0)));
				while(CDR(a0) != tnil){
					a0 = CDR(a0);
					a1 = make_int(val_int(a1) + val_int(CAR(a0)));
				}
				a0 = a1;
			42 =>  								# mconc
				eval_1_arg();
				a1 = a0;
				if( !(IS_ATOM(CAR(a1)) || IS_INT(CAR(a1))) ){
					a2 = CAR(a1);
				    while(CDR(a2)!= tnil){
				    	a2 = CDR(a2);
				    }
				    setcdr(a2,CDR(a1));
				    a1 = a0 =  CAR(a1) ;
				}
				while (CDR(a1) != tnil) {

					if( IS_ATOM(CADR(a1)) || IS_INT(CADR(a1)) ){

		                  a1 = CDR(a1) ;
				    }
				    else{

					  a2 = CADR(a1);
				      while(CDR(a2)!=tnil){
				          a2 = CDR(a2);
				      }
				      setcdr(a2,CDDR(a1));
				      setcdr(a1,CADR(a1)) ;
				    }
				}

			43 =>  								# decimate
				eval_1_arg();
				a1 = a0 ;
				while (CDR(a1) != tnil) {
					if(CDDR(a1) == tnil){
						setcdr(a1, tnil);
						return;
					}
					setcdr(a1, CDDR(a1));
					a1 = CDR(a1);
				}

			* =>
	  			if(CVAL(a4) == undefined){
	  				sys->print("Fonction standard inconnue %s", p_names[a4]);
	  				break;
				}

	  			a4 = CVAL(a4);
	  			eval_car();
		}
	}

	if (CAR(a4) == lambda) {

      	push(a4);
      	push(a2);
      	push(a0);
      	a0 = CDR(a0);
      	evlis();

      	a1 = a0;
      	a0 = pop();
      	a2 = pop();
      	a4 = pop();

      	bind(CADR(a4), a1);

      	a0 = CDDR(a4);
      	progn();

      	unbind();
      	return;
	}
}


# Calcule la puissance d'un nombre.

power (a: int, b:int) :int {
	resultat := 1 ;
	for (i := b; i > 0; i--) {
	    resultat *= a;
	}
	return (resultat);
}


# Evalue un argument.

eval_1_arg() {
	a0 = CADR(a0);
	eval();
}


# Evalue deux arguments.

eval_2_args() {
	push(a0);
	a0 = CADR(CDR(a0));
	eval();
	a1 = a0;
	a0 = pop();
	a0 = CADR(a0);
	eval();
}


# Evalue trois arguments.

eval_3_args() {
    push(a0); a0 = CADR(CDDR(a0)); eval();
    a2 = a0; a0 = pop();
    push(a0); a0 =CADR(CDR(a0)); eval();
    a1 = a0; a0 = pop();
    a0 = CADR(a0); eval();
}


# Evalue une liste d'expressions dans le registre "a0".

progn() {
	a1 = a0;
	for(;;) {
		if(a1 == tnil) {
			return;
		}

		push(a1);
		a0 = CAR(a1);
		eval();
		a1 = pop();
		a1 = CDR(a1);
	}
}


# Evalue tous les elements d'une liste stockee dans "a0".

evlis() {
	a2 = cons(tnil, tnil);
	a4 = a2;
  	push(a4);

  	for (;;) {

      	if(a0 == tnil) {
	      		break;
		}
       	push(a0);
      	push(a2);
      	a0 = CAR(a0);
      	eval();
      	a2 = pop();
      	setcdr(a2, cons(a0, tnil));
      	a2 = CDR(a2);
      	a0 = pop();
      	a0 = CDR(a0);
    }

  	a4 = pop();
  	a0 = CDR(a4);
}


# bind

bind(x: int, y:int) {
  	z := x;

  	push(undefined);
  	while(z != tnil) {
      	push(CVAL(CAR(z)));
      	push(CAR(z));
      	z = CDR(z);
	}

  	while(x != tnil) {
      	setcval(CAR(x), CAR(y));
      	x = CDR(x);
      	y = CDR(y);
    }
}


# unbind

unbind() {
  x: int;
  y: int;

  for(;;)
    {
      x = pop();
      if(x == undefined)
      	return;
      y = pop();
      setcval(x, y);
    }
}


# Fonctions standards de LISP de gestion des doublets.

CAR(adr: int):int {
	return(mem[adr]);
}


CDR(adr: int):int {
	return(mem[adr+1]);
}


CAAR(adr: int):int {
	return(CAR(CAR(adr)));
}


CADR(adr: int):int {
	return(CAR(CDR(adr)));
}


CDAR(adr: int):int {
	return(CDR(CAR(adr)));
}


CDDR(adr: int):int {
	return(CDR(CDR(adr)));
}


# cval renvoie la valeur d'un element.

CVAL(adr: int): int {
	return(mem[adr]);
}


# Les fonctions de detection de type.

IS_ATOM(adr: int): int {
	return(adr >=0 && adr < B_CONS);
}


IS_CONS(adr: int): int {
	return(adr >=B_CONS && adr < B_STACK);
}


IS_STACK(adr: int): int {
	return(adr >=B_STACK && adr < MAXMEM);
}


IS_INT(x: int): int {
	return(x >=MAXMEM);
}


# Fonctions d'assignation de valeur.

setcval(adr: int, val:int) {
	mem[adr] = val;
}


setcar(adr: int, val:int) {
	mem[adr] = val;
}


setcdr(adr: int, val:int) {
	mem[adr+1] = val;
}


# Recadrage d'un entier.

make_int(x: int): int {
	return(x+MAXMEM);
}


val_int(x: int): int {
	return(x-MAXMEM);
}


# Initialise les atomes.

init_atomes() {
	i: int;

	for (i=tnil; i< MAX_ATOMES; i++) {
		setcval(i, undefined) ;
	}

	no_atoms = N_ATOMS;

	for (i=tnil; i< MAX_AUTO_EVAL; i++) {
		setcval(i, i);
	}
}


# Initialise les listes.

init_listes() {
	i: int;

	freelist = tnil;

	for (i= B_CONS; i<= B_STACK; i+=2) {
		setcdr(i, freelist);
		freelist = i;
	}

	sys= load Sys Sys->PATH;

}


# Initialise la pile.

init_stack() {
	sp = B_STACK;
}


# Cree une liste.

cons(x: int, y: int): int {
	res: int;

	if (freelist == tnil) {
		gc();
	}

	setcar(freelist, x);
	res = freelist;
	freelist = CDR(freelist);

	setcdr (res, y) ;

	return(res);
}


# Depassement memoire.

gc() {
	sys->print("Helas, plus de doublets libres!\n");
	exit;
}


# Cree un atome.

cratom(nom_at: string): int {
	res: int;

	if (no_atoms >= MAX_ATOMES) {
		sys->print("Vous avez depasse le nbre maximum d'atomes %d\n !", MAX_ATOMES);
		exit;
	}
	res = no_atoms;
	setcval(res, undefined);
	p_names[no_atoms++] = nom_at;
	return(res);
}
