#include "main.h"

#define MAX_AUTO_EVAL 3
int n_atoms;

#define N_ATOMS 16

char *p_names[MAX_ATS]={
  "nil", "undefined", "t", "quote", "car", "cdr", "add1", "sub1", "lambda", "de", "print", "setq", "aq", "if", "times", "oblist", 0
};

init_stack(){
  sp = B_STACK;
}

init_atomes(){

  int i;
  for(i = 0; i<MAX_ATS; i++)
    {
      CVAL(i) = undefined;
    }
  
  n_atoms = N_ATOMS;
  
  for(i=nil; i<MAX_AUTO_EVAL; i++)
    CVAL(i) = i;
}

init_listes(){
  int i;
  freelist = nil;

  for (i=B_CONS; i <=H_CONS; i-=2)
    {
      CDR(i) = freelist; freelist = i;
    }
}

int
cons(x, y){
  int res;
  if(freelist == nil)gc();
  CAR(freelist) = x;
  res = freelist;
  freelist = CDR(freelist);
  CDR(res) = y;
  return(res);
}

gc(){
  printf("Helas plus de doublets libres!\n");
  exit(0);
}

push(x){
  if(sp == MAXMEM-1)
    {
      init_stack();
      err("Pile debordee\n");
    }
  mem[++sp] = x;
}

int
pop(){
  return(mem[sp--]);
}
